<?php
// verify.php
// SSL sertifika hatası için CA bundle kullan
if (!defined('REQUESTS_SSL_VERIFY')) {
    $caBundle = __DIR__ . '/cacert.pem';
    if (file_exists($caBundle)) {
        // CA bundle dosyası varsa kullan (güvenli)
        define('REQUESTS_SSL_VERIFY', $caBundle);
    } else {
        // CA bundle yoksa geçici olarak devre dışı bırak (güvenlik riski - sadece test için)
        define('REQUESTS_SSL_VERIFY', false);
        error_log('WARNING: CA bundle not found. SSL verification disabled. Please run download_cacert.php');
    }
}

require('config.php');
session_start();

require('razorpay-php/Razorpay.php');
use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;

require_once('../wp-load.php');

$success = true;
$error = "Payment Failed";

if (empty($_POST['razorpay_payment_id']) === false) {
    $api = new Api($keyId, $keySecret);

    try {
        $attributes = array(
            'razorpay_order_id' => $_POST['razorpay_order_id'],
            'razorpay_payment_id' => $_POST['razorpay_payment_id'],
            'razorpay_signature' => $_POST['razorpay_signature']
        );

        // Verify the payment signature
        $api->utility->verifyPaymentSignature($attributes);
    } catch(SignatureVerificationError $e) {
        $success = false;
        $error = 'Razorpay Error : ' . $e->getMessage();
    }
}

if ($success === true) {
    global $wpdb;
    $table_name = 'gmch_razorpay_payment_details';

    $order_id = $_POST['razorpay_order_id'];
    $payment_id = $_POST['razorpay_payment_id'];
    $signature = $_POST['razorpay_signature'];
    $response_data = json_encode($_POST);

    // Payment ID'yi güncelle
    $result = $wpdb->update(
        $table_name,
        [
            'payment_id' => $payment_id,
            'status' => 'success',
            'payment_response' => $response_data
        ],
        ['order_id' => $order_id]
    );

    if ($result !== false) {
        // Başarılı - thank you sayfasına yönlendir
        header('Location: https://grandmaratha.org/?payment_success=1&payment_id=' . $payment_id);
        exit;
    } else {
        $error = 'Error updating payment: ' . $wpdb->last_error;
        $success = false;
    }
}

if ($success === false) {
    // Hata sayfasına yönlendir veya hata göster
    header('Location: https://grandmaratha.org/?error=' . urlencode($error));
    exit;
}
?>

