<?php
/**
 * SSL Yapılandırma Test Scripti
 * Bu script CA bundle dosyasının doğru yolda olup olmadığını kontrol eder
 */

echo "=== SSL Yapılandırma Testi ===\n\n";

// Mevcut dizin
echo "Mevcut Dizin: " . __DIR__ . "\n\n";

// CA Bundle yolları
$possiblePaths = [
    __DIR__ . '/cacert.pem',
    __DIR__ . '/../cacert.pem',
    '/etc/ssl/certs/ca-bundle.crt',
    '/etc/pki/tls/certs/ca-bundle.crt',
    '/usr/share/ssl/certs/ca-bundle.crt',
];

echo "CA Bundle Dosya Kontrolü:\n";
foreach ($possiblePaths as $path) {
    if (file_exists($path)) {
        $size = filesize($path);
        $readable = is_readable($path) ? '✓ Okunabilir' : '✗ Okunamaz';
        echo "✓ BULUNDU: {$path}\n";
        echo "  Boyut: " . number_format($size) . " bytes\n";
        echo "  Durum: {$readable}\n\n";
    } else {
        echo "✗ Bulunamadı: {$path}\n";
    }
}

// REQUESTS_SSL_VERIFY kontrolü
echo "\n=== REQUESTS_SSL_VERIFY Kontrolü ===\n";
if (defined('REQUESTS_SSL_VERIFY')) {
    echo "REQUESTS_SSL_VERIFY tanımlı: " . (is_bool(REQUESTS_SSL_VERIFY) ? (REQUESTS_SSL_VERIFY ? 'true' : 'false') : REQUESTS_SSL_VERIFY) . "\n";
} else {
    echo "REQUESTS_SSL_VERIFY tanımlı değil\n";
}

// cURL ve OpenSSL bilgileri
echo "\n=== Sunucu Bilgileri ===\n";
$curl = curl_version();
echo "cURL Version: " . $curl['version'] . "\n";
echo "SSL Version: " . $curl['ssl_version'] . "\n";
echo "OpenSSL Version: " . OPENSSL_VERSION_TEXT . "\n";

// Test Razorpay bağlantısı
echo "\n=== Razorpay Bağlantı Testi ===\n";
$testUrl = "https://api.razorpay.com/v1/orders";

$ch = curl_init($testUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 2);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 10);

// CA bundle yollarını dene
$caBundleFound = false;
foreach ($possiblePaths as $path) {
    if (file_exists($path) && is_readable($path)) {
        curl_setopt($ch, CURLOPT_CAINFO, $path);
        $caBundleFound = true;
        echo "CA Bundle kullanılıyor: {$path}\n";
        break;
    }
}

if (!$caBundleFound) {
    echo "UYARI: CA bundle bulunamadı, SSL doğrulaması yapılmıyor!\n";
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
}

$response = curl_exec($ch);
$error = curl_error($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($error) {
    echo "✗ HATA: {$error}\n";
} else {
    echo "✓ Bağlantı başarılı (HTTP {$httpCode})\n";
}

echo "\n=== Test Tamamlandı ===\n";
?>
