<?php
// pay.php
// SSL sertifika hatası için CA bundle kullan
// Önce CA bundle dosyasını indirin: php download_cacert.php veya tarayıcıdan açın
if (!defined('REQUESTS_SSL_VERIFY')) {
    $caBundle = __DIR__ . '/cacert.pem';
    if (file_exists($caBundle)) {
        // CA bundle dosyası varsa kullan (güvenli)
        define('REQUESTS_SSL_VERIFY', $caBundle);
    } else {
        // CA bundle yoksa geçici olarak devre dışı bırak (güvenlik riski - sadece test için)
        define('REQUESTS_SSL_VERIFY', false);
        error_log('WARNING: CA bundle not found. SSL verification disabled. Please run download_cacert.php');
    }
}

// Geçici olarak hataları göster (production'da kapatın)
ini_set('display_errors', 1);
error_reporting(E_ALL);

require('config.php');
require('razorpay-php/Razorpay.php');
session_start();

use Razorpay\Api\Api;

// Razorpay API instance'ını oluştur
$api = new Api($keyId, $keySecret);

// Receipt number oluştur
$receiptNumber = uniqid("receipt_", true);

// Razorpay Order oluştur
$orderData = [
    'receipt'         => $receiptNumber,
    'amount'          => $_GET['amount'] * 100, // Rupees to paise
    'currency'        => 'INR',
    'payment_capture' => 1 // auto capture
];

try {
    $razorpayOrder = $api->order->create($orderData);
    $razorpayOrderId = $razorpayOrder['id'];
    $_SESSION['razorpay_order_id'] = $razorpayOrderId;
} catch (Exception $e) {
    die('Error creating order: ' . $e->getMessage());
}

$displayAmount = $orderData['amount'];

if ($displayCurrency !== 'INR') {
    $url = "https://api.fixer.io/latest?symbols=$displayCurrency&base=INR";
    $exchange = json_decode(file_get_contents($url), true);
    $displayAmount = $exchange['rates'][$displayCurrency] * $orderData['amount'] / 100;
}

$checkout = 'manual';
if (isset($_GET['checkout']) && in_array($_GET['checkout'], ['automatic', 'manual'], true)) {
    $checkout = $_GET['checkout'];
}

// Razorpay checkout data
$data = [
    "key"               => $keyId,
    "amount"            => $_GET['amount'],
    "name"              => "Grand Maratha Foundation",
    "description"       => "LEND YOUR SUPPORT & DONATE – IT'S WORTH THE CAUSE",
    "image"             => "https://grandmaratha.org/logo.png",
    "prefill"           => [
        "name"          => $_GET['name'],
        "email"         => $_GET['email'],
        "contact"       => $_GET['phone'],
    ],
    "notes"             => [
        "address"       => $_GET['address'],
        "city"          => $_GET['city'],
        "state"         => $_GET['state'],
        "zipcode"       => $_GET['pincode'],
        "merchant_order_id" => $receiptNumber,
        "country"       => $_GET['donorcountry'],
        "pan"           => $_GET['pan'] ?? '',
        "cause"         => $_GET['cause'] ?? '',
    ],
    "theme"             => [
        "color"         => "#f14b51" // Sitenizin primary rengi
    ],
    "modal"             => [
        "ondismiss"     => "fail",
    ],
    "handler"           => "succ",
    "order_id"          => $razorpayOrderId,
];

if ($displayCurrency !== 'INR') {
    $data['display_currency'] = $displayCurrency;
    $data['display_amount'] = $displayAmount;
}

$json = json_encode($data);

// Checkout sayfasını yükle - $data ve $json değişkenlerini geçir
require("checkout/{$checkout}.php");
?>

