<?php


require('config.php');
session_start();

require('razorpay-php/Razorpay.php');
use Razorpay\Api\Api;
use Razorpay\Api\Errors\SignatureVerificationError;

require_once('../wp-load.php');
get_header(); 
$success = true;
$error = "Payment Failed";
print_r($_POST);
if (empty($_POST['razorpay_payment_id']) === false)
{
    $api = new Api($keyId, $keySecret);

    try
    {
        // Debugging: Check the values being sent
        echo 'Received order ID: ' . $_POST['razorpay_order_id'] . '<br>';
        echo 'Received payment ID: ' . $_POST['razorpay_payment_id'] . '<br>';
        echo 'Received signature: ' . $_POST['razorpay_signature'] . '<br>';

        // Ensure you're using the correct order ID from the session
        $attributes = array(
            'razorpay_order_id' => $_POST['razorpay_order_id'], // Check if it's correct
            'razorpay_payment_id' => $_POST['razorpay_payment_id'],
            'razorpay_signature' => $_POST['razorpay_signature']
        );

        // Verify the payment signature
        $api->utility->verifyPaymentSignature($attributes);
    }
    catch(SignatureVerificationError $e)
    {
        $success = false;
        $error = 'Razorpay Error : ' . $e->getMessage();
    }
}

if ($success === true)
{
    $html = "<p>Your payment was successful</p> 
                </br>
             <p>Payment ID: {$_POST['razorpay_payment_id']}</p>
             <p>Order ID: {$order_id}</p>"; // Display the order ID

    global $wpdb;
    $table_name = 'gmch_razorpay_payment_details'; // Make sure this is the correct table name

    // Assuming you have the following variables set after payment verification
    $order_id = $_SESSION['razorpay_order_id']; // e.g., '456'
    $payment_id = $_POST['razorpay_payment_id']; // Retrieved from the payment response
    $signature = $_POST['razorpay_signature'];
    $response_data = json_encode($_POST);

    echo '<pre>';
    print_r($response_data); // Debugging the response data
    // Update only the payment_id field for the specific order_id
    $result = $wpdb->update(
        $table_name,
        ['payment_id' => $payment_id, 'status' => $response_data], // Data to update
        ['order_id' => $order_id]   // Condition for the update
    );

    if ($result !== false) {
        echo "Payment successfully!";
    } else {
        echo "Error updating payment ID: " . $wpdb->last_error;
    }

    header('Location: '.'https://grandmaratha.org/thankyou/');
}
else
{
    $html = "<p>Your payment failed</p>
             <p>{$error}</p>";
}

echo $html;

get_footer(); ?>
