<?php //echo 'gh';
//exit();
require('config.php');
require('razorpay-php/Razorpay.php');
session_start();

// Create the Razorpay Order

use Razorpay\Api\Api;

$api = new Api($keyId, $keySecret);

//
// We create an razorpay order using orders api
// Docs: https://docs.razorpay.com/docs/orders

$order_id = callApi($_GET['phone']);

$orderData = [
    'receipt'         => $razorpayOrderId,
    'amount'          => $_GET['amount'] * 100, // 2000 rupees in paise
    'currency'        => 'INR',
    'payment_capture' => 1 // auto capture
];

$razorpayOrder = $api->order->create($orderData);

$razorpayOrderId = $razorpayOrder['id'];

$_SESSION['razorpay_order_id'] = $razorpayOrderId;

$displayAmount = $amount = $orderData['amount'];

if ($displayCurrency !== 'INR')
{
    $url = "https://api.fixer.io/latest?symbols=$displayCurrency&base=INR";
    $exchange = json_decode(file_get_contents($url), true);

    $displayAmount = $exchange['rates'][$displayCurrency] * $amount / 100;
}

$checkout = 'manual';

if (isset($_GET['checkout']) and in_array($_GET['checkout'], ['automatic', 'manual'], true))
{
    $checkout = $_GET['checkout'];
}

function callApi($mobileno) {
    
 $curl = curl_init();

curl_setopt_array($curl, array(
  CURLOPT_URL => "https://grandmaratha.org/wp-json/custom-webhook/v1/getOrderId?mobile_number=$mobileno",
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'GET',
  CURLOPT_HTTPHEADER => array(
    'Cookie: PHPSESSID=9a724815235d3e40adf2c82ac0662574; cf7msm_check=1'
  ),
));

$response = curl_exec($curl);

curl_close($curl);

return $response;
        
}

$receiptNumber = uniqid("receipt_", true);

$data = [
    "key"               => $keyId,
    "amount"            => $_GET['amount'],
    "name"              => $_GET['name'],
    "description"       => "LEND YOUR SUPPORT & DONATE – IT’S WORTH THE CAUSE",
    "image"             => "https://grandmaratha.org/wp-content/uploads/2019/12/logo-new.png",
    "prefill"           => [
    "email"             => $_GET['email'],
    "contact"           => $_GET['phone'],
    "billing_tel" => $_GET['phone'],
    ],
    "notes"             => [
    "address"           => $_GET['address'],
    "city"      => $_GET['city'],
    "state"     => $_GET['state'],
    "zipcode"   => $_GET['pincode'],
    "merchant_order_id" => $receiptNumber,
    "country" => $_GET['donorcountry'],
    ],
    "theme"             => [
    "color"             => "#F37254"
    ],
    "modal"             => [
           "ondismiss" => "fail", // You can set this to a function in JavaScript to handle dismiss events
       ],
    "handler"           => "succ",
    "order_id"          => $razorpayOrderId,
];

if ($displayCurrency !== 'INR')
{
    $data['display_currency']  = $displayCurrency;
    $data['display_amount']    = $displayAmount;
}

$json = json_encode($data);

require("checkout/{$checkout}.php");
