<?php
/**
 * CA Bundle İndirme Scripti
 * Bu script CA bundle dosyasını indirir ve proje dizinine kaydeder
 * 
 * Kullanım: Tarayıcıdan açın veya PHP CLI ile çalıştırın:
 * php download_cacert.php
 */

$caBundleUrl = 'https://curl.se/ca/cacert.pem';
$caBundlePath = __DIR__ . '/cacert.pem';

echo "CA Bundle indiriliyor...\n";

// cURL ile indir
$ch = curl_init($caBundleUrl);
$fp = fopen($caBundlePath, 'w');

curl_setopt($ch, CURLOPT_FILE, $fp);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // İndirme sırasında SSL doğrulaması yapmıyoruz
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

$result = curl_exec($ch);
$error = curl_error($ch);
curl_close($ch);
fclose($fp);

if ($error) {
    echo "HATA: " . $error . "\n";
    echo "Alternatif: Manuel olarak indirin:\n";
    echo "curl -o cacert.pem https://curl.se/ca/cacert.pem\n";
    exit(1);
}

if ($result && file_exists($caBundlePath)) {
    $size = filesize($caBundlePath);
    echo "✓ CA Bundle başarıyla indirildi: {$caBundlePath}\n";
    echo "  Dosya boyutu: " . number_format($size) . " bytes\n";
    echo "\nArtık pay.php ve verify.php CA bundle kullanacak.\n";
} else {
    echo "HATA: Dosya indirilemedi veya kaydedilemedi.\n";
    exit(1);
}
?>
