<?php
// checkout/manual.php
// WordPress bağlantısı (varsa)
$wpLoaded = false;
if (file_exists('../wp-load.php')) {
    require_once('../wp-load.php');
    if (function_exists('get_header')) {
        get_header();
        $wpLoaded = true;
    }
}

// WordPress yoksa basit HTML başlangıcı
if (!$wpLoaded) {
    ?><!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment - Grand Maratha Foundation</title>
</head>
<body>
<?php
}

// Veritabanına kayıt yap (WordPress varsa)
if ($wpLoaded && isset($wpdb)) {
    global $wpdb;
    
    // Veritabanına kayıt yap (order oluşturulduktan sonra)
    $order_id = $data['order_id'];
    $receipt_number = $data['notes']['merchant_order_id'];
    $amount = $data['amount'];
    $formattedAmount = number_format($amount, 2);
    $created_at = date('Y-m-d H:i:s');
    $name = $data['name'];
    $email = $data['prefill']['email'];
    $mobileNumber = $data['prefill']['contact'];
    $description = $data['description'];
    $address = $data['notes']['address'];
    $city = $data['notes']['city'];
    $state = $data['notes']['state'];
    $zipcode = $data['notes']['zipcode'];
    $bin_country = $data['notes']['country'];
    $pan = $data['notes']['pan'] ?? '';
    $cause = $data['notes']['cause'] ?? '';

    // Veritabanına kaydet
    $table_name = 'gmch_razorpay_payment_details';

    $data_to_insert = [
        'order_id' => $order_id,
        'receipt_number' => $receipt_number,
        'amount' => $formattedAmount,
        'payment_id' => '', // Payment henüz yapılmadı
        'created_date' => $created_at,
        'name' => $name,
        'email' => $email,
        'mobile_number' => $mobileNumber,
        'address' => $address,
        'city' => $city,
        'state' => $state,
        'pincode' => $zipcode,
        'country' => $bin_country,
        'description' => $description . ($cause ? ' - ' . $cause : ''),
    ];

    // Eğer tabloda pan kolonu varsa
    if (!empty($pan)) {
        $data_to_insert['pan'] = $pan;
    }

    $result = $wpdb->insert($table_name, $data_to_insert);
}

// Razorpay checkout button
?>
<button id="rzp-button1" style="display:none;">Pay with Razorpay</button>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<form name='razorpayform' action="verify.php" method="POST" id="myForm">
    <input type="hidden" name="razorpay_payment_id" id="razorpay_payment_id">
    <input type="hidden" name="razorpay_signature" id="razorpay_signature">
    <input type="hidden" name="razorpay_order_id" id="razorpay_order_id">
    <input type="hidden" name="response" id="response" value="">
</form>

<script>
    window.onload = function() {
        document.getElementById('rzp-button1').click();
    };

    // Checkout options
    var options = <?php echo $json; ?>;

    // Handler function
    options.handler = function (response){
        document.getElementById('razorpay_payment_id').value = response.razorpay_payment_id;
        document.getElementById('razorpay_signature').value = response.razorpay_signature;
        document.getElementById('razorpay_order_id').value = response.razorpay_order_id;
        document.getElementById('response').value = JSON.stringify(response);
        document.razorpayform.submit();
    };

    options.theme.image_padding = false;

    options.modal = {
        ondismiss: function() {
            window.location.href = "https://grandmaratha.org/#donation-form";
        },
        escape: true,
        backdropclose: false
    };

    var rzp = new Razorpay(options);

    document.getElementById('rzp-button1').onclick = function(e){
        rzp.open();
        e.preventDefault();
    };

    rzp.on('payment.failed', function (response) {
        alert('Payment failed: ' + response.error.description);
        window.location.href = "https://grandmaratha.org/#donation-form";
    });
</script>

<?php 
if ($wpLoaded && function_exists('get_footer')) {
    get_footer();
} else {
    ?>
</body>
</html>
<?php
}
?>







