# SSL Sertifika Hatası Çözümü

## Sorun
CPanel'e yükledikten sonra şu hata alınıyor:
```
Error creating order: cURL error 60: SSL certificate OpenSSL verify result: self signed certificate in certificate chain (19)
```

## ✅ Çözüm (Uygulandı)

CA Bundle dosyası kullanılarak SSL doğrulaması güvenli şekilde yapılıyor. Eğer CA bundle dosyası yoksa, geçici olarak SSL doğrulaması devre dışı bırakılıyor (sadece test için).

## Yapılan Değişiklikler

### 1. download_cacert.php (YENİ)
- CA bundle dosyasını otomatik indiren script eklendi
- Tarayıcıdan veya PHP CLI ile çalıştırılabilir

### 2. pay.php
- CA bundle dosyası varsa kullanılıyor (güvenli)
- CA bundle yoksa geçici olarak devre dışı bırakılıyor (uyarı loglanıyor)
- `REQUESTS_SSL_VERIFY` constant'ı otomatik olarak ayarlanıyor

### 3. verify.php
- Aynı CA bundle kontrolü eklendi
- Payment verification sırasında SSL hatası önlenir

### 4. razorpay-php/src/Request.php
- Requests kütüphanesine `verify` seçeneği zaten ekli
- `REQUESTS_SSL_VERIFY` constant'ı otomatik kontrol ediliyor

## Kurulum Adımları

### Adım 1: CA Bundle Dosyasını İndirin

**Yöntem 1: PHP Script ile (Önerilen)**
1. Tarayıcıdan şu adresi açın: `https://yourdomain.com/download_cacert.php`
2. Veya cPanel File Manager'dan `download_cacert.php` dosyasını çalıştırın
3. Script otomatik olarak `cacert.pem` dosyasını indirecek

**Yöntem 2: Manuel İndirme (SSH veya cPanel Terminal)**
```bash
cd /home/username/public_html
curl -o cacert.pem https://curl.se/ca/cacert.pem
```

**Yöntem 3: cPanel File Manager**
1. cPanel → File Manager
2. Ana dizine gidin
3. "Upload" butonuna tıklayın
4. `cacert.pem` dosyasını manuel olarak indirip yükleyin (https://curl.se/ca/cacert.pem)

### Adım 2: Dosya İzinlerini Kontrol Edin

CA bundle dosyasının okunabilir olduğundan emin olun:
```bash
chmod 644 cacert.pem
```

### Adım 3: Test Edin

1. Formu doldurun ve submit edin
2. `pay.php` açılmalı ve Razorpay order oluşturulmalı
3. SSL hatası almamalısınız
4. Razorpay checkout modal'ı görünmeli

## Güvenlik Notu

✅ **CA Bundle Kullanımı**: SSL doğrulaması aktif ve güvenli
⚠️ **CA Bundle Yoksa**: SSL doğrulaması devre dışı (sadece test için - production'da kullanmayın)

## Sorun Devam Ederse

### 1. CA Bundle Dosyasının Varlığını Kontrol Edin
```php
<?php
// test_cacert.php
$caBundle = __DIR__ . '/cacert.pem';
if (file_exists($caBundle)) {
    echo "✓ CA Bundle bulundu: " . filesize($caBundle) . " bytes\n";
} else {
    echo "✗ CA Bundle bulunamadı. download_cacert.php çalıştırın.\n";
}
```

### 2. Sunucu cURL ve OpenSSL Versiyonlarını Kontrol Edin
```php
<?php
// test_ssl.php
$curl = curl_version();
echo "cURL Version: " . $curl['version'] . "\n";
echo "OpenSSL Version: " . OPENSSL_VERSION_TEXT . "\n";
echo "SSL Version: " . $curl['ssl_version'] . "\n";
```

### 3. cURL Hatalarını Detaylı Görmek İçin
```php
// pay.php'de try-catch bloğuna ekleyin
catch (Exception $e) {
    error_log('Razorpay Error: ' . $e->getMessage());
    error_log('Stack trace: ' . $e->getTraceAsString());
    die('Error creating order: ' . $e->getMessage());
}
```

### 4. CPanel'de Kontrol Edin
- **Error Log**: cPanel → Metrics → Errors
- **PHP Error Log**: cPanel → Metrics → Errors → PHP Errors
- **File Permissions**: CA bundle dosyası okunabilir olmalı (644)

### 5. Alternatif: Sunucu CA Bundle Kullanımı
Eğer sunucuda sistem CA bundle varsa, onu kullanabilirsiniz:
```php
// pay.php'de
$systemCaBundle = '/etc/ssl/certs/ca-bundle.crt'; // veya sunucunuzdaki yol
if (file_exists($systemCaBundle)) {
    define('REQUESTS_SSL_VERIFY', $systemCaBundle);
}
```

## Dosya Yapısı

```
/
├── cacert.pem              # CA Bundle dosyası (indirilmeli)
├── download_cacert.php     # CA Bundle indirme scripti
├── pay.php                 # Razorpay order oluşturma (güncellendi)
├── verify.php              # Payment verification (güncellendi)
├── config.php              # Razorpay API keys
└── razorpay-php/           # Razorpay PHP SDK
    └── src/
        └── Request.php     # SSL verify desteği var
```

## Özet

✅ CA Bundle çözümü uygulandı
✅ Güvenli SSL doğrulaması aktif
✅ Otomatik fallback mekanizması var
✅ Detaylı hata loglama eklendi







