# Razorpay Entegrasyonu - CPanel Yükleme Talimatları

## 📁 Yüklenecek Dosyalar

### Ana Dizin
- `index.html` (güncellenmiş - images/ klasörü kullanıyor)
- `pay.php`
- `verify.php`
- `config.php`
- `1.jpg`, `2.jpg`, `3.jpg`, `4.jpg` (hero slider için)

### Klasörler
- `checkout/manual.php`
- `razorpay-php/` (tüm klasör - zaten ana dizinde)
- `images/` (tüm klasör - sadece kullanılan resimler)

## 🚀 CPanel'e Yükleme Adımları

### 1. Klasör Yapısını Oluşturun

CPanel File Manager'da şu yapıyı oluşturun:

```
public_html/
├── donate-now/ (veya istediğiniz klasör adı)
│   ├── index.html
│   ├── pay.php
│   ├── verify.php
│   ├── config.php
│   ├── checkout/
│   │   └── manual.php
│   └── razorpay-php/
│       └── (tüm içerik)
```

### 2. Dosyaları Yükleyin

1. **Ana dosyalar**: `index.html`, `pay.php`, `verify.php`, `config.php` → Ana dizine
2. **Checkout klasörü**: `checkout/manual.php` → `checkout/` klasörüne
3. **Razorpay PHP SDK**: `razorpay-php/` klasörünün tamamını kopyalayın

### 3. config.php'yi Düzenleyin

`config.php` dosyasını açın ve Razorpay key'lerinizi kontrol edin:

```php
$keyId = 'rzp_live_copF7NUnRYu4PD'; // Razorpay Key ID
$keySecret = '2fqjUHnba7DaM8CJ0O69is89'; // Razorpay Key Secret
```

⚠️ **ÖNEMLİ**: Key'lerin doğru olduğundan emin olun!

### 4. WordPress Yolunu Kontrol Edin

`checkout/manual.php` ve `verify.php` dosyalarında WordPress bağlantısı var:

```php
require_once('../wp-load.php');
```

**Yol kontrolü:**
- Eğer WordPress `public_html/` içindeyse ve dosyalar `public_html/donate-now/` içindeyse → `../wp-load.php` ✅ DOĞRU
- Eğer farklı bir yapı varsa, yolu buna göre ayarlayın

### 5. Veritabanı Tablosunu Kontrol Edin

WordPress veritabanında şu tablo olmalı:
- Tablo adı: `gmch_razorpay_payment_details`

**Tablo yapısı (örnek):**
- order_id
- receipt_number
- amount
- payment_id
- created_date
- name
- email
- mobile_number
- address
- city
- state
- pincode
- country
- description
- status (opsiyonel)
- payment_response (opsiyonel)

### 6. Dosya İzinlerini Ayarlayın

CPanel File Manager'da:
- PHP dosyaları: **644** veya **755**
- Klasörler: **755**

## ✅ Test Etme

1. `index.html` sayfasını açın
2. Formu doldurun
3. "Proceed to Payment" butonuna tıklayın
4. `pay.php` açılmalı ve Razorpay checkout modal'ı görünmeli
5. Test ödemesi yapın
6. `verify.php` çalışmalı ve veritabanına kayıt yapılmalı

## 🔧 Sorun Giderme

### Hata: "Call to undefined function"
- `razorpay-php/` klasörünün tamamının yüklendiğinden emin olun

### Hata: "wp-load.php not found"
- WordPress yolunu kontrol edin
- `../wp-load.php` yerine doğru yolu yazın

### Hata: "Table doesn't exist"
- Veritabanı tablosunun mevcut olduğundan emin olun
- Tablo adını kontrol edin: `gmch_razorpay_payment_details`

### Payment modal açılmıyor
- Razorpay Key ID ve Secret Key'in doğru olduğundan emin olun
- Browser console'da hata var mı kontrol edin

## 📝 Notlar

- Tüm dosyalar CPanel'e yüklendiğinde çalışacak şekilde hazırlandı
- WordPress bağlantısı `../wp-load.php` ile yapılıyor
- Veritabanı kayıtları `checkout/manual.php` içinde yapılıyor
- Payment verification `verify.php` içinde yapılıyor
- Success redirect: `https://grandmaratha.org/thankyou/`

## 🔐 Güvenlik

- `config.php` dosyasını `.htaccess` ile koruyabilirsiniz
- Key Secret'ı asla frontend'de kullanmayın
- Production'da error reporting kapalı olmalı (zaten kapalı)

