# Manuel Temizleme Komutları

## Terminal'de Çalıştırılacak Komutlar

### 1. Workspace Dizinine Git
```powershell
cd "C:\Users\serda\Desktop\Kasım 2025\grand-aysen"
```

### 2. Mevcut Dizini Kontrol Et
```powershell
Get-Location
pwd
```

### 3. "Donate Now_files" Klasörünün Varlığını Kontrol Et
```powershell
Test-Path "Donate Now_files"
```

### 4. Gereksiz Dosyaları Sil (.indir, .css, .html)
```powershell
Get-ChildItem "Donate Now_files" -File | Where-Object { $_.Extension -in @('.indir', '.css', '.html') } | Remove-Item -Force
```

### 5. Kullanılmayan Resim Dosyalarını Sil
```powershell
$unusedImages = @('10.jpg','11.jpg','12.jpg','13.jpg','14.jpg','15.jpg','16.jpg','17.jpg','18.jpg','19.jpg','20.jpg','21.jpg','22.jpg','23.jpg','24.jpg','25.jpg','26.jpg','27.jpg','28.jpg','29.jpg','30.jpg','31.jpg','32.jpg','33.jpg','34.jpg','about-ceo.jpg','ganesh-randave.png','nagesh-mirashe.png','parshuram-narwade.png','sanskar-ughade.png','testi-1-3.png','testi-1-4.png','testimonial.png','trustee1.png','trustee2.png','trustee3.png','donation-1-1.jpg','1712528175850942')
foreach($img in $unusedImages) { Remove-Item "Donate Now_files\$img" -Force -ErrorAction SilentlyContinue }
```

### 6. Gereksiz Klasörleri Sil
```powershell
$dirs = @('css','css(1)','css2','js','knppid3quu')
foreach($dir in $dirs) { Remove-Item "Donate Now_files\$dir" -Recurse -Force -ErrorAction SilentlyContinue }
```

### 7. Klasörü "images" Olarak Yeniden Adlandır
```powershell
if (Test-Path "images") { Remove-Item "images" -Recurse -Force }
Rename-Item "Donate Now_files" "images" -Force
```

### 8. razorpay-php Klasörünü Kopyala
```powershell
if (Test-Path "howtodonate-razorpay\razorpay-php") {
    if (Test-Path "razorpay-php") { Remove-Item "razorpay-php" -Recurse -Force }
    Copy-Item "howtodonate-razorpay\razorpay-php" -Destination "razorpay-php" -Recurse -Force
    Write-Host "✓ razorpay-php kopyalandı"
} else {
    Write-Host "⚠ razorpay-php klasörü bulunamadı"
}
```

### 9. Sonuçları Kontrol Et
```powershell
Test-Path "images"
Test-Path "razorpay-php"
Get-ChildItem "images" | Measure-Object | Select-Object -ExpandProperty Count
```

---

## Alternatif: Tek Komutla Tüm İşlemler

Eğer yukarıdaki komutlar çalışmazsa, şu Python script'ini kullanabilirsiniz:

### Python Script Oluştur
```powershell
@"
# -*- coding: utf-8 -*-
import os
import shutil

workspace = r'C:\Users\serda\Desktop\Kasım 2025\grand-aysen'
os.chdir(workspace)
print(f'Çalışma dizini: {os.getcwd()}')

folder_path = 'Donate Now_files'
extensions_to_delete = ['.indir', '.css', '.html']
files_to_delete = [
    '10.jpg', '11.jpg', '12.jpg', '13.jpg', '14.jpg', '15.jpg', '16.jpg', '17.jpg',
    '18.jpg', '19.jpg', '20.jpg', '21.jpg', '22.jpg', '23.jpg', '24.jpg', '25.jpg',
    '26.jpg', '27.jpg', '28.jpg', '29.jpg', '30.jpg', '31.jpg', '32.jpg', '33.jpg',
    '34.jpg', 'about-ceo.jpg', 'ganesh-randave.png', 'nagesh-mirashe.png',
    'parshuram-narwade.png', 'sanskar-ughade.png', 'testi-1-3.png', 'testi-1-4.png',
    'testimonial.png', 'trustee1.png', 'trustee2.png', 'trustee3.png',
    'donation-1-1.jpg', '1712528175850942'
]
dirs_to_delete = ['css', 'css(1)', 'css2', 'js', 'knppid3quu']

if os.path.exists(folder_path):
    print(f'İşleniyor: {folder_path}')
    deleted = 0
    for root, dirs, files in os.walk(folder_path):
        for file in files:
            if any(file.endswith(ext) for ext in extensions_to_delete):
                try:
                    os.remove(os.path.join(root, file))
                    deleted += 1
                except: pass
    print(f'Silindi: {deleted} dosya')
    
    for f in files_to_delete:
        p = os.path.join(folder_path, f)
        if os.path.exists(p):
            try: os.remove(p)
            except: pass
    
    for d in dirs_to_delete:
        p = os.path.join(folder_path, d)
        if os.path.exists(p):
            try: shutil.rmtree(p)
            except: pass
    
    if os.path.exists(folder_path):
        if os.path.exists('images'):
            shutil.rmtree('images')
        os.rename(folder_path, 'images')
        print('✓ images olarak yeniden adlandırıldı')

if os.path.exists('howtodonate-razorpay/razorpay-php'):
    if os.path.exists('razorpay-php'):
        shutil.rmtree('razorpay-php')
    shutil.copytree('howtodonate-razorpay/razorpay-php', 'razorpay-php')
    print('✓ razorpay-php kopyalandı')

print('✓ Tamamlandı!')
"@ | Out-File -FilePath "cleanup.py" -Encoding UTF8
```

### Python Script'i Çalıştır
```powershell
python cleanup.py
```

### Script'i Sil (İsteğe Bağlı)
```powershell
Remove-Item cleanup.py -Force
```

---

## Hata Durumunda Kontrol Komutları

### Klasör Yapısını Kontrol Et
```powershell
Get-ChildItem | Select-Object Name, PSIsContainer
```

### "Donate Now_files" İçindeki Dosyaları Listele
```powershell
Get-ChildItem "Donate Now_files" -File | Select-Object Name, Extension | Format-Table
```

### "Donate Now_files" İçindeki Klasörleri Listele
```powershell
Get-ChildItem "Donate Now_files" -Directory | Select-Object Name
```

### Encoding Sorunu Varsa
```powershell
[Console]::OutputEncoding = [System.Text.Encoding]::UTF8
$PSDefaultParameterValues['*:Encoding'] = 'utf8'
```

---

## Beklenen Sonuç

İşlemler tamamlandıktan sonra:
- ✅ "Donate Now_files" klasörü "images" olarak yeniden adlandırılmış olmalı
- ✅ "images" klasöründe sadece kullanılan resimler kalmalı
- ✅ "razorpay-php" klasörü ana dizinde olmalı
- ✅ Gereksiz dosyalar (.indir, .css, .html) silinmiş olmalı

---

## Hata Bildirimi

Herhangi bir hata alırsanız, şu bilgileri paylaşın:
1. Hangi komutu çalıştırdınız?
2. Tam hata mesajı nedir?
3. `Get-Location` komutunun çıktısı nedir?
4. `Test-Path "Donate Now_files"` komutunun çıktısı nedir?







